define([
    'underscore',
    'backbone',
    'modules/appointments/list-section/appointments-section-view',
    'text!modules/appointments/booked/booked-appointments.html',

    'text!modules/appointments/booked/booked-appointments-empty.html',

    'modules/appointments/booked/booked-appointments-list-view',
    'modules/appointments/booked/booked-appointments-collection',
    'modules/appointments/booked/pagination/booked-appointments-top-pagination-view',
    'modules/appointments/booked/pagination/booked-appointments-bottom-pagination-view',
], function (
    _,
    Backbone,
    AppointmentsSectionView,
    template,

    noAppointmentsTemplate,

    BookedAppointmentsListView,
    BookedAppointments,
    TopPaginationView,
    BottomPaginationView
) {
    'use strict';

    return AppointmentsSectionView.extend({
        template: _.template(template),
        regions: {
            paginationControlTopRegion: '#appointments-pagination-top-controls',
            appointmentsListRegion: '.booked-appointments-contain',
            paginationControlBottomRegion: '#appointments-pagination-bottom-controls',
        },

        collectionEvents: {
            'ready': function() {
                if (this._isShown) {
                    this.showPage();
                }
            },
        },

        showPage: function() {
            var PageableCollection = Backbone.PageableCollection.extend({
                dataType: 'appointments',
                mode: 'client',
                state: {
                    pageSize: 5,
                },
            });

            var data = new PageableCollection({}, {collection: this.collection});


            this.showAppointmentsView({collection: data});
            this.showPaginationControls({collection: data});
        },
        // functions in AppointmentsSectionView:
        // _initializeSectionView
        onShow: function() {
            this.showPage();

        },
        // onDestroy
        // showAppointmentsView
        showPaginationControls: function(options) {
            // Create an instance of PageableCollection for the paginator with the given collection


            this.getRegion('paginationControlTopRegion').show(new TopPaginationView({collection: options.collection}));
            this.getRegion('paginationControlBottomRegion').show(
                new BottomPaginationView({collection: options.collection}));
            // this.showChildView('primaryLocation', new PaginationView({collection: this.model}));
        },
        onRender: function() {
            this._initializeSectionView({
                noAppointmentsTemplate: noAppointmentsTemplate,
                AppointmentsListView: BookedAppointmentsListView,
            });
            this.onShow();
        },
    });
});
